/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_bs.content.logistics.vault;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryWrapper;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import uwu.lopyluna.create_bs.content.TierMaterials;
import uwu.lopyluna.create_bs.content.logistics.vault.TieredVaultBlock;
import uwu.lopyluna.create_bs.registry.BSBlockEntities;

public class TieredVaultBlockEntity
extends SmartBlockEntity
implements IMultiBlockEntityContainer.Inventory {
    protected LazyOptional<IItemHandler> itemCapability;
    protected ItemStackHandler inventory;
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity;
    protected int radius;
    protected int length;
    protected Direction.Axis axis;
    TierMaterials tierMaterials;

    public TieredVaultBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, TierMaterials tierMaterials) {
        super(type, pos, state);
        this.tierMaterials = tierMaterials;
        this.inventory = new ItemStackHandler(tierMaterials.capacity){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                TieredVaultBlockEntity.this.updateComparators();
                TieredVaultBlockEntity.this.m_6596_();
                TieredVaultBlockEntity.this.sendData();
            }
        };
        this.itemCapability = LazyOptional.empty();
        this.radius = 1;
        this.length = 1;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((BlockEntity)this);
    }

    protected void updateComparators() {
        TieredVaultBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null || this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_151543_(controllerBE.f_58858_);
        BlockPos pos = controllerBE.m_58899_();
        for (int y = 0; y < controllerBE.radius; ++y) {
            for (int z = 0; z < (controllerBE.axis == Direction.Axis.X ? controllerBE.radius : controllerBE.length); ++z) {
                for (int x = 0; x < (controllerBE.axis == Direction.Axis.Z ? controllerBE.radius : controllerBE.length); ++x) {
                    this.f_58857_.m_46717_(pos.m_7918_(x, y, z), this.m_58900_().m_60734_());
                }
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.m_58899_();
        } else if (!this.lastKnownPos.equals((Object)this.f_58858_)) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.f_58858_.m_123341_() == this.controller.m_123341_() && this.f_58858_.m_123342_() == this.controller.m_123342_() && this.f_58858_.m_123343_() == this.controller.m_123343_();
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.f_58858_;
    }

    public TieredVaultBlockEntity getControllerBE() {
        if (this.isController() || this.f_58857_ == null) {
            return this;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        if (blockEntity instanceof TieredVaultBlockEntity) {
            return (TieredVaultBlockEntity)blockEntity;
        }
        return null;
    }

    public void removeController(boolean keepContents) {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        this.updateConnectivity = true;
        this.controller = null;
        this.radius = 1;
        this.length = 1;
        BlockState state = this.m_58900_();
        if (TieredVaultBlock.isVault(state, this.tierMaterials)) {
            state = (BlockState)state.m_61124_((Property)TieredVaultBlock.LARGE, (Comparable)Boolean.valueOf(false));
            this.f_58857_.m_7731_(this.f_58858_, state, 22);
        }
        this.itemCapability.invalidate();
        this.m_6596_();
        this.sendData();
    }

    public void setController(BlockPos controller) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.itemCapability.invalidate();
        this.m_6596_();
        this.sendData();
    }

    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controller;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.radius;
        int prevLength = this.length;
        this.updateConnectivity = compound.m_128441_("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.m_128441_("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("LastKnownPos"));
        }
        if (compound.m_128441_("Controller")) {
            this.controller = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
        }
        if (this.isController()) {
            this.radius = compound.m_128451_("Size");
            this.length = compound.m_128451_("Length");
        }
        if (compound.m_128441_("Inventory")) {
            this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        }
        if (!clientPacket) {
            return;
        }
        boolean bl = changeOfController = !Objects.equals(controllerBefore, this.controller);
        if (this.f_58857_ != null && (changeOfController || prevSize != this.radius || prevLength != this.length)) {
            this.f_58857_.m_6550_(this.m_58899_(), Blocks.f_50016_.m_49966_(), this.m_58900_());
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.m_128379_("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.m_128405_("Size", this.radius);
            compound.m_128405_("Length", this.length);
        }
        super.write(compound, clientPacket);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        if (!clientPacket) {
            compound.m_128359_("StorageType", "CombinedInv");
        }
    }

    public ItemStackHandler getInventoryOfBlock() {
        return this.inventory;
    }

    public void applyInventoryToBlock(ItemStackHandler handler) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, i < handler.getSlots() ? handler.getStackInSlot(i) : ItemStack.f_41583_);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (this.isItemHandlerCap(cap)) {
            this.initCapability();
            return this.itemCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    private void initCapability() {
        if (this.itemCapability.isPresent()) {
            return;
        }
        if (!this.isController()) {
            TieredVaultBlockEntity controllerBE = this.getControllerBE();
            if (controllerBE == null) {
                return;
            }
            controllerBE.initCapability();
            this.itemCapability = controllerBE.itemCapability;
            return;
        }
        boolean alongZ = TieredVaultBlock.getVaultBlockAxis(this.m_58900_(), this.tierMaterials) == Direction.Axis.Z;
        IItemHandlerModifiable[] invs = new IItemHandlerModifiable[this.length * this.radius * this.radius];
        for (int yOffset = 0; yOffset < this.length; ++yOffset) {
            for (int xOffset = 0; xOffset < this.radius; ++xOffset) {
                for (int zOffset = 0; zOffset < this.radius; ++zOffset) {
                    BlockPos vaultPos = alongZ ? this.f_58858_.m_7918_(xOffset, zOffset, yOffset) : this.f_58858_.m_7918_(yOffset, xOffset, zOffset);
                    TieredVaultBlockEntity vaultAt = null;
                    if (this.f_58857_ != null) {
                        vaultAt = (TieredVaultBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)BSBlockEntities.VAULTS.get(this.tierMaterials).get()), (BlockGetter)this.f_58857_, (BlockPos)vaultPos);
                    }
                    invs[yOffset * this.radius * this.radius + xOffset * this.radius + zOffset] = vaultAt != null ? vaultAt.inventory : new ItemStackHandler();
                }
            }
        }
        VersionedInventoryWrapper itemHandler = new VersionedInventoryWrapper((IItemHandlerModifiable)new CombinedInvWrapper(invs));
        this.itemCapability = LazyOptional.of(() -> TieredVaultBlockEntity.lambda$initCapability$0((IItemHandler)itemHandler));
    }

    public static int getMaxLength(int radius, TierMaterials tier) {
        return radius * tier.multiplierLength;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        BlockState state = this.m_58900_();
        if (this.f_58857_ != null && TieredVaultBlock.isVault(state, this.tierMaterials)) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)TieredVaultBlock.LARGE, (Comparable)Boolean.valueOf(this.radius > 2)), 6);
        }
        this.itemCapability.invalidate();
        this.m_6596_();
    }

    public Direction.Axis getMainConnectionAxis() {
        return this.getMainAxisOf((BlockEntity)this);
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return this.getMaxWidth();
        }
        return TieredVaultBlockEntity.getMaxLength(width, this.tierMaterials);
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.length;
    }

    public int getWidth() {
        return this.radius;
    }

    public void setHeight(int height) {
        this.length = height;
    }

    public void setWidth(int width) {
        this.radius = width;
    }

    public boolean hasInventory() {
        return true;
    }

    private static /* synthetic */ IItemHandler lambda$initCapability$0(IItemHandler itemHandler) {
        return itemHandler;
    }
}

